//Falcon2-11B DATASET v1.0 Category: Building a POP3 Client ; Style: distributed
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <string.h>

#define MAX_BUFFER 512

int main() {
    // Create a TCP socket
    int sockfd;
    struct sockaddr_in servaddr;
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        fprintf(stderr, "ERROR opening socket\n");
        exit(1);
    }
    
    // Set up the server address
    servaddr.sin_family = AF_INET;
    servaddr.sin_port = htons(110);
    servaddr.sin_addr.s_addr = INADDR_ANY;
    if (bind(sockfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) < 0) {
        fprintf(stderr, "ERROR on binding\n");
        exit(1);
    }
    
    // Start listening for connections
    listen(sockfd, 5);
    printf("Waiting for connection...\n");
    
    struct sockaddr_in cliaddr;
    int clilen = sizeof(cliaddr);
    int newfd = accept(sockfd, (struct sockaddr *)&cliaddr, &clilen);
    if (newfd < 0) {
        fprintf(stderr, "ERROR on accept\n");
        exit(1);
    }
    
    char buffer[MAX_BUFFER];
    int n = read(newfd, buffer, MAX_BUFFER);
    if (n < 0) {
        fprintf(stderr, "ERROR reading from socket\n");
        exit(1);
    }
    printf("Server: %s\n", buffer);
    n = write(newfd, "USER foo\r\n", 10);
    if (n < 0) {
        fprintf(stderr, "ERROR writing to socket\n");
        exit(1);
    }
    n = read(newfd, buffer, MAX_BUFFER);
    if (n < 0) {
        fprintf(stderr, "ERROR reading from socket\n");
        exit(1);
    }
    printf("Server: %s\n", buffer);
    n = write(newfd, "PASS bar\r\n", 10);
    if (n < 0) {
        fprintf(stderr, "ERROR writing to socket\n");
        exit(1);
    }
    n = read(newfd, buffer, MAX_BUFFER);
    if (n < 0) {
        fprintf(stderr, "ERROR reading from socket\n");
        exit(1);
    }
    printf("Server: %s\n", buffer);
    n = write(newfd, "LIST\r\n", 7);
    if (n < 0) {
        fprintf(stderr, "ERROR writing to socket\n");
        exit(1);
    }
    n = read(newfd, buffer, MAX_BUFFER);
    if (n < 0) {
        fprintf(stderr, "ERROR reading from socket\n");
        exit(1);
    }
    printf("Server: %s\n", buffer);
    close(newfd);
    
    return 0;
}