//Falcon-180B DATASET v1.0 Category: Database Indexing System ; Style: careful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_SIZE 1000
#define MAX_KEYS 50
#define MAX_KEY_LEN 50

typedef struct {
    char keys[MAX_KEYS][MAX_KEY_LEN];
    int values[MAX_SIZE];
    int num_keys;
} Database;

void init_database(Database *db) {
    db->num_keys = 0;
}

void add_key(Database *db, char *key) {
    int i, j;
    for (i = 0; i < db->num_keys; i++) {
        if (strcmp(db->keys[i], key) == 0) {
            return;
        }
    }
    for (i = 0; i < db->num_keys; i++) {
        if (db->keys[i][0] == '\0') {
            strcpy(db->keys[i], key);
            db->values[i] = 0;
            db->num_keys++;
            return;
        }
    }
}

void add_value(Database *db, int value) {
    int i;
    for (i = 0; i < db->num_keys; i++) {
        if (db->values[i] == value) {
            return;
        }
    }
    for (i = 0; i < db->num_keys; i++) {
        if (db->values[i] == 0) {
            db->values[i] = value;
            return;
        }
    }
}

void print_database(Database *db) {
    int i;
    for (i = 0; i < db->num_keys; i++) {
        printf("%s: %d\n", db->keys[i], db->values[i]);
    }
}

int main() {
    Database db;
    init_database(&db);
    add_key(&db, "John");
    add_value(&db, 25);
    add_value(&db, 30);
    add_value(&db, 35);
    add_key(&db, "Jane");
    add_value(&db, 28);
    add_value(&db, 32);
    add_value(&db, 38);
    print_database(&db);
    return 0;
}