//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: visionary
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the weather types
#define SUNNY 0
#define CLOUDY 1
#define RAINY 2
#define SNOWY 3

// Define the temperature range
#define MIN_TEMP -20
#define MAX_TEMP 40

// Define the wind speed range
#define MIN_WIND 0
#define MAX_WIND 100

// Define the humidity range
#define MIN_HUMIDITY 0
#define MAX_HUMIDITY 100

// Define the number of days to simulate
#define NUM_DAYS 30

// Create a struct to store the weather data
typedef struct {
    int type;
    int temperature;
    int windSpeed;
    int humidity;
} WeatherData;

// Create a function to generate a random weather data
WeatherData generateWeatherData() {
    WeatherData weatherData;

    // Generate a random weather type
    weatherData.type = rand() % 4;

    // Generate a random temperature
    weatherData.temperature = MIN_TEMP + (rand() % (MAX_TEMP - MIN_TEMP + 1));

    // Generate a random wind speed
    weatherData.windSpeed = MIN_WIND + (rand() % (MAX_WIND - MIN_WIND + 1));

    // Generate a random humidity
    weatherData.humidity = MIN_HUMIDITY + (rand() % (MAX_HUMIDITY - MIN_HUMIDITY + 1));

    return weatherData;
}

// Create a function to print the weather data
void printWeatherData(WeatherData weatherData) {
    switch (weatherData.type) {
        case SUNNY:
            printf("Sunny");
            break;
        case CLOUDY:
            printf("Cloudy");
            break;
        case RAINY:
            printf("Rainy");
            break;
        case SNOWY:
            printf("Snowy");
            break;
    }

    printf(" | Temperature: %d degrees Celsius", weatherData.temperature);
    printf(" | Wind speed: %d km/h", weatherData.windSpeed);
    printf(" | Humidity: %d %%", weatherData.humidity);
}

// Create a function to simulate the weather for a given number of days
void simulateWeather(int numDays) {
    // Create an array to store the weather data
    WeatherData weatherData[numDays];

    // Generate the weather data for each day
    for (int i = 0; i < numDays; i++) {
        weatherData[i] = generateWeatherData();
    }

    // Print the weather data for each day
    for (int i = 0; i < numDays; i++) {
        printf("Day %d: ", i + 1);
        printWeatherData(weatherData[i]);
        printf("\n");
    }
}

int main() {
    // Seed the random number generator
    srand(time(NULL));

    // Simulate the weather for 30 days
    simulateWeather(NUM_DAYS);

    return 0;
}