//Falcon-180B DATASET v1.0 Category: Building a SMTP Client ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <ctype.h>
#include <fcntl.h>

#define BUF_SIZE 1024
#define SERVER "smtp.gmail.com"
#define PORT 587
#define USER "your_email@gmail.com"
#define PASS "your_password"

int main() {
    int sockfd, n;
    struct sockaddr_in serv_addr;
    char send_buf[BUF_SIZE], recv_buf[BUF_SIZE];
    char *message = "Subject: Test\r\n\r\nThis is a test message.\r\n";

    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == 0) {
        perror("socket failed");
        exit(EXIT_FAILURE);
    }

    if (connect(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) == -1) {
        perror("connect failed");
        exit(EXIT_FAILURE);
    }

    printf("Connected to SMTP server.\n");

    if (send(sockfd, USER, strlen(USER), 0) == -1) {
        perror("send failed");
        exit(EXIT_FAILURE);
    }

    if (send(sockfd, PASS, strlen(PASS), 0) == -1) {
        perror("send failed");
        exit(EXIT_FAILURE);
    }

    if (recv(sockfd, recv_buf, BUF_SIZE, 0) == -1) {
        perror("recv failed");
        exit(EXIT_FAILURE);
    }

    printf("Server response: %s\n", recv_buf);

    if (send(sockfd, "MAIL FROM:<your_email@gmail.com>\r\n", strlen("MAIL FROM:<your_email@gmail.com>\r\n"), 0) == -1) {
        perror("send failed");
        exit(EXIT_FAILURE);
    }

    if (recv(sockfd, recv_buf, BUF_SIZE, 0) == -1) {
        perror("recv failed");
        exit(EXIT_FAILURE);
    }

    printf("Server response: %s\n", recv_buf);

    if (send(sockfd, "RCPT TO:<recipient_email@gmail.com>\r\n", strlen("RCPT TO:<recipient_email@gmail.com>\r\n"), 0) == -1) {
        perror("send failed");
        exit(EXIT_FAILURE);
    }

    if (recv(sockfd, recv_buf, BUF_SIZE, 0) == -1) {
        perror("recv failed");
        exit(EXIT_FAILURE);
    }

    printf("Server response: %s\n", recv_buf);

    if (send(sockfd, "DATA\r\n", strlen("DATA\r\n"), 0) == -1) {
        perror("send failed");
        exit(EXIT_FAILURE);
    }

    if (send(sockfd, message, strlen(message), 0) == -1) {
        perror("send failed");
        exit(EXIT_FAILURE);
    }

    if (recv(sockfd, recv_buf, BUF_SIZE, 0) == -1) {
        perror("recv failed");
        exit(EXIT_FAILURE);
    }

    printf("Server response: %s\n", recv_buf);

    close(sockfd);

    return 0;
}