//GPT-4o-mini DATASET v1.0 Category: Automated Fortune Teller ; Style: surrealist
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_FORTUNES 10

const char *fortunes[MAX_FORTUNES] = {
    "An old shadow shall visit you at dawn.",
    "Whispers of the cosmos will lead you to a hidden door.",
    "The stars align just right for a surreal waltz tonight.",
    "Beware the orange cats, they know your secrets.",
    "A coin tossed will change the direction of your dreams.",
    "Amidst the ruins, a phoenix shall rise in slow motion.",
    "The taste of forbidden fruit will be yours to savor.",
    "The moon has sent you a shimmering invitation.",
    "A rabbit will cross your path, carrying crucial news.",
    "The rain will sing to you as petals fall from the sky."
};

void print_infinite_silence() {
    for (int i = 0; i < 5; i++) {
        printf("\n                                         . . . \n");
    }
}

void dance_of_the_calmness() {
    for (int i = 0; i < 100; i++) {
        printf("\rThe universe is breathing... %d%%", i + 1);
        fflush(stdout);
        usleep(50000); // Sleep for 50 milliseconds
    }
    printf("\n");
}

int main() {
    srand(time(NULL));
    int number_of_fortunes = sizeof(fortunes) / sizeof(fortunes[0]);
    
    printf("Welcome to the Surreal Fortune Teller!\n");
    printf("Here, the ordinary steps aside for the extraordinary.\n");
    printf("Inhale deeply, let the universe unfold...\n");
    
    print_infinite_silence();
    
    printf("Prepare yourself for insight...\n");
    dance_of_the_calmness();
    
    printf("You have entered the realm of the unknown...\n");
    printf("Here is your fortune:\n");
    
    int index = rand() % number_of_fortunes;
    printf("\033[1;32m%s\033[0m\n", fortunes[index]);  // Print in green color for enthusiasm
    
    // Creating a labyrinth of motivations
    printf("Now close your eyes and visualize:\n");
    for (int i = 0; i < 5; i++) {
        printf("\nThe golden walls of a dream labyrinth are closing in...");
        usleep(700000); // Sleep for 700 milliseconds
        printf("\r                                    \n");
    }
    
    printf("Embrace the surreal; the shadows dance on the edge of your thoughts.\n");
    printf("What will you do with this ancient echo of wisdom?\n");
    
    char choice[10];
    printf("Will you follow or ignore your fortune? (follow/ignore): ");
    fgets(choice, sizeof(choice), stdin);
    
    // Remove new line character from input
    size_t len = strlen(choice);
    if (len > 0 && choice[len - 1] == '\n') {
        choice[len - 1] = '\0'; 
    }

    if (strcmp(choice, "follow") == 0) {
        printf("You have chosen to dance with your fortune, as the cosmos applauds your courage!\n");
    } else if (strcmp(choice, "ignore") == 0) {
        printf("The lingering echo of your choice shall haunt you like a soft melody in a twilight dream.\n");
    } else {
        printf("The void does not understand your ambiguity, it yawns.\n");
    }

    printf("As the curtain of time draws, remember...\n");
    print_infinite_silence();
    printf("The surreal will always nestle within your thoughts.\n");
    printf("Thank you for visiting; may your dreams guide your reality.\n");
    
    return 0;
}