//Falcon-180B DATASET v1.0 Category: Product Inventory System ; Style: intelligent
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_SIZE 100

typedef struct {
    char name[MAX_SIZE];
    int quantity;
    double price;
} Product;

void addProduct(Product *products, int numProducts, char *name, int quantity, double price) {
    if (numProducts >= MAX_SIZE) {
        printf("Error: Inventory is full.\n");
        return;
    }

    strcpy(products[numProducts].name, name);
    products[numProducts].quantity = quantity;
    products[numProducts].price = price;

    numProducts++;
}

void printInventory(Product *products, int numProducts) {
    printf("Inventory:\n");
    for (int i = 0; i < numProducts; i++) {
        printf("%s - Quantity: %d - Price: $%.2f\n", products[i].name, products[i].quantity, products[i].price);
    }
}

void searchProduct(Product *products, int numProducts, char *name) {
    for (int i = 0; i < numProducts; i++) {
        if (strcmp(products[i].name, name) == 0) {
            printf("Product found:\n");
            printf("%s - Quantity: %d - Price: $%.2f\n", products[i].name, products[i].quantity, products[i].price);
            return;
        }
    }

    printf("Product not found.\n");
}

void removeProduct(Product *products, int numProducts, char *name) {
    for (int i = 0; i < numProducts; i++) {
        if (strcmp(products[i].name, name) == 0) {
            printf("Product removed:\n");
            printf("%s - Quantity: %d - Price: $%.2f\n", products[i].name, products[i].quantity, products[i].price);
            for (int j = i; j < numProducts - 1; j++) {
                products[j] = products[j + 1];
            }
            numProducts--;
            return;
        }
    }

    printf("Product not found.\n");
}

int main() {
    Product products[MAX_SIZE];
    int numProducts = 0;

    addProduct(products, numProducts, "Apple", 10, 1.00);
    addProduct(products, numProducts, "Banana", 5, 0.50);
    addProduct(products, numProducts, "Orange", 15, 0.75);

    printInventory(products, numProducts);

    searchProduct(products, numProducts, "Banana");

    removeProduct(products, numProducts, "Orange");

    printInventory(products, numProducts);

    return 0;
}