//Falcon-180B DATASET v1.0 Category: Network Topology Mapper ; Style: futuristic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_NODES 100
#define MAX_EDGES 500
#define MAX_LABEL_LENGTH 50

typedef struct {
    char label[MAX_LABEL_LENGTH];
    int id;
} Node;

typedef struct {
    int source;
    int destination;
    int weight;
} Edge;

Node nodes[MAX_NODES];
Edge edges[MAX_EDGES];
int num_nodes = 0;
int num_edges = 0;

void add_node(char* label) {
    nodes[num_nodes].label[0] = '\0';
    strncat(nodes[num_nodes].label, label, MAX_LABEL_LENGTH - 1);
    nodes[num_nodes].id = num_nodes;
    num_nodes++;
}

void add_edge(int source, int destination, int weight) {
    edges[num_edges].source = source;
    edges[num_edges].destination = destination;
    edges[num_edges].weight = weight;
    num_edges++;
}

void print_nodes() {
    printf("Nodes:\n");
    for (int i = 0; i < num_nodes; i++) {
        printf("%d. %s\n", i, nodes[i].label);
    }
}

void print_edges() {
    printf("Edges:\n");
    for (int i = 0; i < num_edges; i++) {
        printf("%d -> %d (%d)\n", edges[i].source, edges[i].destination, edges[i].weight);
    }
}

int main() {
    add_node("Alpha");
    add_node("Beta");
    add_node("Gamma");
    add_node("Delta");

    add_edge(0, 1, 10);
    add_edge(1, 2, 20);
    add_edge(2, 3, 30);

    print_nodes();
    print_edges();

    return 0;
}