//MISTRAL-7B DATASET v1.0 Category: Metadata Extractor ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#pragma pack(push, 1)
typedef struct {
    char id[4];
    int version;
    char name[32];
    char author[32];
    char description[128];
} BraveMetadata;
#pragma pack(pop)

void extract_metadata(const char *filename) {
    int fd;
    BraveMetadata metadata;
    struct stat file_stat;

    fd = open(filename, O_RDONLY);
    if (fd < 0) {
        perror("Error opening file");
        return;
    }

    if (fstat(fd, &file_stat) < 0) {
        perror("Error getting file size");
        close(fd);
        return;
    }

    if (file_stat.st_size < sizeof(BraveMetadata)) {
        printf("File size too small to contain metadata\n");
        close(fd);
        return;
    }

    if (read(fd, &metadata, sizeof(BraveMetadata)) != sizeof(BraveMetadata)) {
        perror("Error reading metadata");
        close(fd);
        return;
    }

    close(fd);

    printf("ID: %s\n", metadata.id);
    printf("Version: %d\n", metadata.version);
    printf("Name: %s\n", metadata.name);
    printf("Author: %s\n", metadata.author);
    printf("Description: %s\n", metadata.description);
}

int main(int argc, char *argv[]) {
    if (argc != 2) {
        printf("Usage: %s <file>\n", argv[0]);
        return 1;
    }

    extract_metadata(argv[1]);

    return 0;
}