//Gemma-7B DATASET v1.0 Category: Password Strength Checker ; Style: genius
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define PASSWORD_LENGTH 20

char *generate_password(int length)
{
    char *password = malloc(length);
    for (int i = 0; i < length; i++)
    {
        password[i] = rand() % 26 + 97;
    }
    return password;
}

int main()
{
    char password[PASSWORD_LENGTH];
    printf("Enter your password: ");
    fgets(password, PASSWORD_LENGTH, stdin);

    int strength = check_password_strength(password);
    switch (strength)
    {
        case 0:
            printf("Your password is too weak. Please try again.\n");
            break;
        case 1:
            printf("Your password is somewhat weak. Please consider changing it.\n");
            break;
        case 2:
            printf("Your password is strong. Good job!\n");
            break;
        default:
            printf("Error: Invalid password strength.\n");
            break;
    }

    return 0;
}

int check_password_strength(char *password)
{
    int length = strlen(password);
    if (length < 8)
    {
        return 0;
    }
    for (int i = 0; i < length; i++)
    {
        if (!isupper(password[i]) && !isdigit(password[i]))
        {
            return 1;
        }
    }
    return 2;
}