//Falcon-180B DATASET v1.0 Category: Text Summarizer ; Style: surprised
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define MAX_SENTENCE_LENGTH 100
#define MAX_SENTENCES 1000
#define MIN_SENTENCE_LENGTH 5

typedef struct {
    char text[MAX_SENTENCE_LENGTH];
    int length;
} Sentence;

int numSentences = 0;
Sentence sentences[MAX_SENTENCES];

void addSentence(char* newSentence) {
    if (numSentences >= MAX_SENTENCES) {
        printf("Error: Too many sentences.\n");
        return;
    }

    int newLength = strlen(newSentence);
    if (newLength < MIN_SENTENCE_LENGTH) {
        printf("Error: Sentence is too short.\n");
        return;
    }

    strcpy(sentences[numSentences].text, newSentence);
    sentences[numSentences].length = newLength;

    numSentences++;
}

void printSentences() {
    for (int i = 0; i < numSentences; i++) {
        printf("%s (%d characters)\n", sentences[i].text, sentences[i].length);
    }
}

void summarizeText() {
    int totalLength = 0;

    for (int i = 0; i < numSentences; i++) {
        totalLength += sentences[i].length;
    }

    int maxSummaryLength = (int) (0.5 * totalLength);

    char summary[MAX_SENTENCE_LENGTH];
    summary[0] = '\0';

    int summaryLength = 0;

    for (int i = 0; i < numSentences; i++) {
        int sentenceLength = sentences[i].length;

        if (summaryLength + sentenceLength > maxSummaryLength) {
            break;
        }

        strcat(summary, sentences[i].text);
        summaryLength += sentenceLength;
    }

    printf("Summary: %s (%d characters)\n", summary, summaryLength);
}

int main() {
    addSentence("The quick brown fox jumps over the lazy dog.");
    addSentence("Sphinx of black quartz, judge my vow.");

    printSentences();

    summarizeText();

    return 0;
}