//Falcon-180B DATASET v1.0 Category: Database querying ; Style: calm
#include <stdio.h>
#include <sqlite3.h>

// Function prototypes
static int callback(void *data, int argc, char **argv, char **azColName);
void *data;

int main() {
    sqlite3 *db;
    char *zErrMsg = 0;
    int rc;

    // Open a database and create a table
    rc = sqlite3_open("test.db", &db);
    if( rc ) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        return 1;
    }

    char *sql = "CREATE TABLE IF NOT EXISTS users(" \
                "id INTEGER PRIMARY KEY," \
                "name TEXT," \
                "age INTEGER);";

    char *errMsg = 0;
    rc = sqlite3_exec(db, sql, 0, 0, &errMsg);
    if( rc!= SQLITE_OK ) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    } else {
        fprintf(stdout, "Table created successfully\n");
    }

    // Insert data into the table
    sql = "INSERT INTO users(name, age) VALUES('John', 25);";
    rc = sqlite3_exec(db, sql, 0, 0, &errMsg);
    if( rc!= SQLITE_OK ) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    } else {
        fprintf(stdout, "Data inserted successfully\n");
    }

    // Query the table and display the results
    sql = "SELECT * FROM users;";
    rc = sqlite3_exec(db, sql, callback, 0, &errMsg);
    if( rc!= SQLITE_OK ) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    } else {
        fprintf(stdout, "Query executed successfully\n");
    }

    sqlite3_close(db);
    return 0;
}

static int callback(void *data, int argc, char **argv, char **azColName) {
    for(int i=0; i<argc; i++) {
        printf("%s = %s\n", azColName[i], argv[i]? argv[i] : "NULL");
    }
    printf("\n");
    return 0;
}