//Falcon-180B DATASET v1.0 Category: Database querying ; Style: safe
#include <stdio.h>
#include <stdlib.h>
#include <sqlite3.h>

// Define the database schema
static const char *sql_create_table =
    "CREATE TABLE IF NOT EXISTS users("
    "id INTEGER PRIMARY KEY AUTOINCREMENT,"
    "name TEXT NOT NULL,"
    "age INTEGER NOT NULL);";

// Function to execute SQL queries
static int callback(void *data, int argc, char **argv, char **azColName)
{
    for (int i = 0; i < argc; i++)
    {
        printf("%s = %s\n", azColName[i], argv[i]? argv[i] : "NULL");
    }
    printf("\n");
    return 0;
}

// Function to handle errors
static void error_callback(void *data, int argc, char **argv, char **azColName)
{
    fprintf(stderr, "Error: %s\n", argv[0]);
}

int main()
{
    // Open the database
    sqlite3 *db;
    int rc = sqlite3_open("test.db", &db);

    if (rc)
    {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        return 1;
    }

    // Create the table
    rc = sqlite3_exec(db, sql_create_table, NULL, NULL, NULL);

    if (rc!= SQLITE_OK)
    {
        fprintf(stderr, "SQL error: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        return 1;
    }

    // Insert some data
    const char *sql_insert_data =
        "INSERT INTO users(name, age) VALUES('John', 30);";

    rc = sqlite3_exec(db, sql_insert_data, NULL, NULL, NULL);

    if (rc!= SQLITE_OK)
    {
        fprintf(stderr, "SQL error: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        return 1;
    }

    // Query the data
    const char *sql_query_data = "SELECT * FROM users;";

    rc = sqlite3_exec(db, sql_query_data, callback, NULL, &error_callback);

    if (rc!= SQLITE_OK)
    {
        fprintf(stderr, "SQL error: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        return 1;
    }

    // Close the database
    sqlite3_close(db);
    return 0;
}