//Gemma-7B DATASET v1.0 Category: Fitness Tracker ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define a struct to store fitness tracker data
typedef struct FitnessTracker {
    int stepsTaken;
    int caloriesBurned;
    int heartRate;
    time_t timestamp;
} FitnessTracker;

// Function to calculate the number of calories burned
int calculateCalories(int stepsTaken, int age) {
    int caloriesBurned = (stepsTaken * 0.015) + (age * 0.003);
    return caloriesBurned;
}

// Function to calculate the heart rate
int calculateHeartRate(int age, int stepsTaken) {
    int heartRate = 200 - (100 - (age / 2)) - (stepsTaken * 0.08);
    return heartRate;
}

int main() {
    // Create a fitness tracker object
    FitnessTracker fitnessTracker;

    // Initialize the fitness tracker data
    fitnessTracker.stepsTaken = 0;
    fitnessTracker.caloriesBurned = 0;
    fitnessTracker.heartRate = 0;
    fitnessTracker.timestamp = time(NULL);

    // Loop to simulate fitness tracker activity
    for (int i = 0; i < 10; i++) {
        // Increase the number of steps taken
        fitnessTracker.stepsTaken++;

        // Calculate the number of calories burned
        fitnessTracker.caloriesBurned = calculateCalories(fitnessTracker.stepsTaken, 25);

        // Calculate the heart rate
        fitnessTracker.heartRate = calculateHeartRate(25, fitnessTracker.stepsTaken);

        // Print the fitness tracker data
        printf("Steps taken: %d\n", fitnessTracker.stepsTaken);
        printf("Calories burned: %d\n", fitnessTracker.caloriesBurned);
        printf("Heart rate: %d\n", fitnessTracker.heartRate);
        printf("Timestamp: %s\n", ctime(fitnessTracker.timestamp));
        printf("\n");
    }

    return 0;
}