//Gemma-7B DATASET v1.0 Category: Product Inventory System ; Style: secure
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100

typedef struct Item {
    char name[50];
    int quantity;
    double price;
} Item;

Item items[MAX_ITEMS];

void addItem(char *name, int quantity, double price) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] == '\0') {
            strcpy(items[i].name, name);
            items[i].quantity = quantity;
            items[i].price = price;
            return;
        }
    }

    printf("Error: Inventory is full.\n");
}

void updateItemQuantity(char *name, int quantity) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (strcmp(items[i].name, name) == 0) {
            items[i].quantity = quantity;
            return;
        }
    }

    printf("Error: Item not found.\n");
}

void getItemPrice(char *name, double *price) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (strcmp(items[i].name, name) == 0) {
            *price = items[i].price;
            return;
        }
    }

    printf("Error: Item not found.\n");
}

int main() {
    addItem("Apple", 10, 1.20);
    addItem("Banana", 5, 0.80);
    addItem("Orange", 7, 0.90);

    updateItemQuantity("Apple", 15);

    double price;
    getItemPrice("Banana", &price);

    printf("Item name: %s\n", items[0].name);
    printf("Item quantity: %d\n", items[0].quantity);
    printf("Item price: %.2lf\n", items[0].price);
    printf("Item price: %.2lf\n", price);

    return 0;
}