//GEMINI-pro DATASET v1.0 Category: System event logger ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#ifdef WIN32
#include <windows.h>
#else
#include <syslog.h>
#endif

#define LOG_BUFFER_SIZE 256

static FILE *g_log_file = NULL;

static void write_to_log(const char *format, ...)
{
    static char buffer[LOG_BUFFER_SIZE];
    va_list arg_ptr;

    va_start(arg_ptr, format);
    vsnprintf(buffer, LOG_BUFFER_SIZE, format, arg_ptr);
    va_end(arg_ptr);

#ifdef WIN32
    OutputDebugString(buffer);
#else
    syslog(LOG_NOTICE, "%s", buffer);
#endif

    if (g_log_file) {
        fprintf(g_log_file, "%s", buffer);
        fflush(g_log_file);
    }
}

static void open_log(const char *filename)
{
    if (!filename) {
        filename = "log.txt";
    }

    g_log_file = fopen(filename, "a");
    if (!g_log_file) {
        write_to_log("Could not open log file \"%s\".", filename);
    }
}

static void close_log(void)
{
    if (g_log_file) {
        fclose(g_log_file);
        g_log_file = NULL;
    }
}

int main(int argc, char *argv[])
{
    open_log("log.txt");

    write_to_log("Application started.");

    for (int i = 0; i < 100; i++) {
        write_to_log("Iteration %d.", i);
    }

    write_to_log("Application ended.");

    close_log();

    return 0;
}