//Falcon-180B DATASET v1.0 Category: Database querying ; Style: funny
#include <stdio.h>
#include <stdlib.h>
#include <sqlite3.h>

// Function to execute SQL queries
static int callback(void *data, int argc, char **argv, char **azColName) {
    for (int i = 0; i < argc; i++) {
        printf("%s = %s\n", azColName[i], argv[i]? argv[i] : "NULL");
    }
    printf("\n");
    return 0;
}

// Function to handle errors
static void error_callback(void *data, int argc, char **argv, char **azColName) {
    fprintf(stderr, "Error: %s\n", argv[0]);
}

// Main function
int main() {
    sqlite3 *db;
    char *zErrMsg = 0;
    int rc;

    // Open the database
    rc = sqlite3_open("example.db", &db);

    // Check if there are any errors
    if (rc) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        return 1;
    }

    // Create a table
    char *sql = "CREATE TABLE IF NOT EXISTS users("
                "id INTEGER PRIMARY KEY AUTOINCREMENT,"
                "name TEXT NOT NULL,"
                "age INTEGER,"
                "email TEXT);";
    rc = sqlite3_exec(db, sql, NULL, NULL, &zErrMsg);

    // Check if there are any errors
    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
    } else {
        printf("Table created successfully\n");
    }

    // Insert some data
    char *insert_sql = "INSERT INTO users(name, age, email) VALUES('John Doe', 30, 'johndoe@example.com');";
    rc = sqlite3_exec(db, insert_sql, NULL, NULL, &zErrMsg);

    // Check if there are any errors
    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
    } else {
        printf("Data inserted successfully\n");
    }

    // Query the data
    char *query_sql = "SELECT * FROM users;";
    rc = sqlite3_exec(db, query_sql, callback, NULL, &zErrMsg);

    // Check if there are any errors
    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
    }

    // Close the database
    sqlite3_close(db);

    return 0;
}