//GEMINI-pro DATASET v1.0 Category: Medical Store Management System ; Style: statistical
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Structure to store medicine details
typedef struct Medicine {
    char name[50];
    int quantity;
    float price;
} Medicine;

// Array to store all the medicines
Medicine medicines[100];

// Number of medicines in the store
int num_medicines = 0;

// Function to add a new medicine to the store
void add_medicine(char *name, int quantity, float price) {
    strcpy(medicines[num_medicines].name, name);
    medicines[num_medicines].quantity = quantity;
    medicines[num_medicines].price = price;
    num_medicines++;
}

// Function to search for a medicine in the store
int search_medicine(char *name) {
    for (int i = 0; i < num_medicines; i++) {
        if (strcmp(medicines[i].name, name) == 0) {
            return i;
        }
    }
    return -1;
}

// Function to sell a medicine
void sell_medicine(char *name, int quantity) {
    int index = search_medicine(name);
    if (index == -1) {
        printf("Medicine not found.\n");
        return;
    }
    if (medicines[index].quantity < quantity) {
        printf("Insufficient quantity.\n");
        return;
    }
    medicines[index].quantity -= quantity;
    printf("Medicine sold successfully.\n");
}

// Function to print the inventory of the store
void print_inventory() {
    printf("Inventory:\n");
    for (int i = 0; i < num_medicines; i++) {
        printf("%s %d %f\n", medicines[i].name, medicines[i].quantity, medicines[i].price);
    }
}

// Main function
int main() {
    // Add some sample medicines to the store
    add_medicine("Paracetamol", 100, 10.0);
    add_medicine("Ibuprofen", 50, 15.0);
    add_medicine("Aspirin", 25, 5.0);

    // Print the inventory of the store
    print_inventory();

    // Sell some medicines
    sell_medicine("Paracetamol", 20);
    sell_medicine("Ibuprofen", 10);

    // Print the inventory of the store again
    print_inventory();

    return 0;
}