//Falcon-180B DATASET v1.0 Category: File system simulation ; Style: mind-bending
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_FILE_NAME 100
#define MAX_FILE_SIZE 1024
#define MAX_NUM_FILES 100

typedef struct {
    char name[MAX_FILE_NAME];
    char content[MAX_FILE_SIZE];
    int size;
} File;

File files[MAX_NUM_FILES];
int num_files = 0;

void create_file(char* name, char* content) {
    if (num_files >= MAX_NUM_FILES) {
        printf("Error: Too many files.\n");
        return;
    }
    strcpy(files[num_files].name, name);
    strcpy(files[num_files].content, content);
    files[num_files].size = strlen(content);
    num_files++;
}

void delete_file(char* name) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            printf("Deleted file: %s\n", name);
            num_files--;
            return;
        }
    }
    printf("File not found: %s\n", name);
}

void rename_file(char* old_name, char* new_name) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, old_name) == 0) {
            strcpy(files[i].name, new_name);
            printf("Renamed file: %s -> %s\n", old_name, new_name);
            return;
        }
    }
    printf("File not found: %s\n", old_name);
}

void list_files() {
    int i;
    for (i = 0; i < num_files; i++) {
        printf("%s (%d bytes)\n", files[i].name, files[i].size);
    }
}

int main() {
    create_file("test.txt", "Hello, world!");
    list_files();
    rename_file("test.txt", "hello.txt");
    list_files();
    delete_file("hello.txt");
    list_files();
    return 0;
}