//MISTRAL-7B DATASET v1.0 Category: Sorting ; Style: single-threaded
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdbool.h>

#define MAX_SIZE 1000
#define WORD_SIZE 50

typedef struct {
    char word[WORD_SIZE];
    int count;
} Word;

bool is_alpha(char c) {
    return isalpha(c);
}

void process_word(char *str, Word *words, int *num_words) {
    int i;
    bool word_found = false;

    for (i = 0; i < *num_words; i++) {
        if (strcmp(words[i].word, str) == 0) {
            words[i].count++;
            word_found = true;
            break;
        }
    }

    if (!word_found) {
        strcpy(words[*num_words].word, str);
        words[*num_words].count = 1;
        (*num_words)++;
    }
}

int main() {
    char input[MAX_SIZE];
    Word words[MAX_SIZE / WORD_SIZE];
    int num_words = 0;

    printf("Enter a sentence or a phrase (type 'quit' to exit):\n");

    while (true) {
        fgets(input, MAX_SIZE, stdin);

        input[strcspn(input, "\n")] = '\0';

        if (strcmp(input, "quit") == 0) {
            break;
        }

        char *str = strtok(input, " ");

        while (str != NULL) {
            process_word(str, words, &num_words);
            str = strtok(NULL, " ");
        }
    }

    printf("\nWord count:\n");

    for (int i = 0; i < num_words; i++) {
        printf("%s: %d\n", words[i].word, words[i].count);
    }

    return 0;
}