//GEMINI-pro DATASET v1.0 Category: Chess AI ; Style: decentralized
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BOARD_SIZE 8
#define BLACK 0
#define WHITE 1
#define EMPTY 2
#define KNIGHT 0
#define BISHOP 1
#define ROOK 2
#define QUEEN 3
#define KING 4
#define PAWN 5

typedef struct {
  int x;
  int y;
} Point;

typedef struct {
  int type;
  int color;
  Point position;
} Piece;

typedef struct {
  Piece board[BOARD_SIZE][BOARD_SIZE];
} Board;

void print_board(Board* board) {
  for (int i = 0; i < BOARD_SIZE; i++) {
    for (int j = 0; j < BOARD_SIZE; j++) {
      Piece piece = board->board[i][j];
      char symbol = ' ';
      switch (piece.type) {
        case KNIGHT:
          symbol = 'N';
          break;
        case BISHOP:
          symbol = 'B';
          break;
        case ROOK:
          symbol = 'R';
          break;
        case QUEEN:
          symbol = 'Q';
          break;
        case KING:
          symbol = 'K';
          break;
        case PAWN:
          symbol = 'P';
          break;
        default:
          break;
      }
      printf("%c ", symbol);
    }
    printf("\n");
  }
}

int main() {
  Board board;
  memset(&board, 0, sizeof(Board));

  // Initialize the board
  for (int i = 0; i < BOARD_SIZE; i++) {
    board.board[i][1].type = PAWN;
    board.board[i][1].color = BLACK;
    board.board[i][6].type = PAWN;
    board.board[i][6].color = WHITE;
  }

  board.board[0][0].type = ROOK;
  board.board[0][0].color = BLACK;
  board.board[1][0].type = KNIGHT;
  board.board[1][0].color = BLACK;
  board.board[2][0].type = BISHOP;
  board.board[2][0].color = BLACK;
  board.board[3][0].type = QUEEN;
  board.board[3][0].color = BLACK;
  board.board[4][0].type = KING;
  board.board[4][0].color = BLACK;
  board.board[5][0].type = BISHOP;
  board.board[5][0].color = BLACK;
  board.board[6][0].type = KNIGHT;
  board.board[6][0].color = BLACK;
  board.board[7][0].type = ROOK;
  board.board[7][0].color = BLACK;

  board.board[0][7].type = ROOK;
  board.board[0][7].color = WHITE;
  board.board[1][7].type = KNIGHT;
  board.board[1][7].color = WHITE;
  board.board[2][7].type = BISHOP;
  board.board[2][7].color = WHITE;
  board.board[3][7].type = QUEEN;
  board.board[3][7].color = WHITE;
  board.board[4][7].type = KING;
  board.board[4][7].color = WHITE;
  board.board[5][7].type = BISHOP;
  board.board[5][7].color = WHITE;
  board.board[6][7].type = KNIGHT;
  board.board[6][7].color = WHITE;
  board.board[7][7].type = ROOK;
  board.board[7][7].color = WHITE;

  print_board(&board);

  return 0;
}