//Falcon-180B DATASET v1.0 Category: Expense Tracker ; Style: authentic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_CATEGORIES 10
#define MAX_ITEMS 100

struct category {
    char name[50];
    int count;
};

struct item {
    char name[50];
    float cost;
    int category;
};

struct category categories[MAX_CATEGORIES];
struct item items[MAX_ITEMS];

int num_categories = 0;
int num_items = 0;

void add_category(char *name) {
    strcpy(categories[num_categories].name, name);
    categories[num_categories].count = 0;
    num_categories++;
}

int get_category_index(char *name) {
    for (int i = 0; i < num_categories; i++) {
        if (strcmp(categories[i].name, name) == 0) {
            return i;
        }
    }
    add_category(name);
    return num_categories - 1;
}

void add_item(char *name, float cost, int category) {
    strcpy(items[num_items].name, name);
    items[num_items].cost = cost;
    items[num_items].category = category;
    categories[category].count++;
    num_items++;
}

void print_categories() {
    printf("Categories:\n");
    for (int i = 0; i < num_categories; i++) {
        printf("%d. %s (%d items)\n", i+1, categories[i].name, categories[i].count);
    }
}

void print_items() {
    printf("\nItems:\n");
    for (int i = 0; i < num_items; i++) {
        printf("%d. %s - $%.2f (Category: %d)\n", i+1, items[i].name, items[i].cost, items[i].category);
    }
}

int main() {
    add_category("Groceries");
    add_category("Entertainment");
    add_category("Travel");

    add_item("Milk", 2.99, 0);
    add_item("Eggs", 1.99, 0);
    add_item("Bread", 3.49, 0);
    add_item("Movie Ticket", 10.99, 1);
    add_item("Airplane Ticket", 299.99, 2);

    print_categories();
    print_items();

    return 0;
}