//Falcon2-11B DATASET v1.0 Category: System administration ; Style: visionary
#include <stdio.h>
#include <stdlib.h>

int main(int argc, char *argv[])
{
    // Get the number of arguments
    int numArgs = argc;
    
    // Check if there are at least two arguments
    if (numArgs < 2)
    {
        fprintf(stderr, "Usage: %s <username> <password>\n", argv[0]);
        exit(EXIT_FAILURE);
    }
    
    // Get the username and password from the arguments
    char *username = argv[1];
    char *password = argv[2];
    
    // Check if the username is empty
    if (username == NULL)
    {
        fprintf(stderr, "Username cannot be empty\n");
        exit(EXIT_FAILURE);
    }
    
    // Check if the password is empty
    if (password == NULL)
    {
        fprintf(stderr, "Password cannot be empty\n");
        exit(EXIT_FAILURE);
    }
    
    // Create a file to store the password
    FILE *file = fopen("passwords.txt", "w");
    if (file == NULL)
    {
        fprintf(stderr, "Error opening file\n");
        exit(EXIT_FAILURE);
    }
    
    // Write the username and password to the file
    fprintf(file, "%s:%s\n", username, password);
    fclose(file);
    
    // Print a success message
    printf("Password saved successfully\n");
    
    return 0;
}