//GEMINI-pro DATASET v1.0 Category: Modern Encryption ; Style: Cryptic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define ENCRYPT 1
#define DECRYPT 0

unsigned long long int pk, n;

unsigned long long int gcd(unsigned long long int a, unsigned long long int b) {
  unsigned long long int c;
  while (b) {
    c = a % b;
    a = b;
    b = c;
  }
  return a;
}

unsigned long long int modinv(unsigned long long int a, unsigned long long int m) {
  unsigned long long int b0 = a, t, q;
  unsigned long long int x0 = 0, x1 = 1;
  if (m == 1)
    return 1;
  while (a > 1) {
    q = a / m;
    t = m;
    m = a % m, a = t;
    t = x0;
    x0 = x1 - q * x0;
    x1 = t;
  }
  if (x1 < 0)
    x1 += b0;
  return x1;
}

unsigned long long int power(unsigned long long int base, unsigned long long int exponent, unsigned long long int modulus) {
  if (modulus == 1)
    return 0;
  unsigned long long int result = 1;
  base = base % modulus;
  while (exponent > 0) {
    if (exponent % 2 == 1)
      result = (result * base) % modulus;
    exponent = exponent >> 1;
    base = (base * base) % modulus;
  }
  return result;
}

void gen_keys() {
  unsigned long long int p = 3, q = 7;
  n = p * q;
  unsigned long long int phi_n = (p - 1) * (q - 1);
  pk = 11;
  while (gcd(pk, phi_n) != 1)
    pk++;
}

unsigned long long int encrypt(unsigned long long int plaintext) {
  return power(plaintext, pk, n);
}

unsigned long long int decrypt(unsigned long long int ciphertext) {
  return power(ciphertext, modinv(pk, n), n);
}

int main() {
  gen_keys();
  unsigned long long int plaintext = 1234;
  unsigned long long int ciphertext = encrypt(plaintext);
  unsigned long long int decryptedtext = decrypt(ciphertext);
  printf("Plaintext: %llu\n", plaintext);
  printf("Ciphertext: %llu\n", ciphertext);
  printf("Decryptedtext: %llu\n", decryptedtext);
  return 0;
}