//Falcon2-11B DATASET v1.0 Category: Networking ; Style: statistical
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

int main(int argc, char *argv[]) {
  int sockfd, portno, n;
  struct sockaddr_in serv_addr;
  char buffer[256];

  // Create a socket
  if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
    perror("ERROR opening socket");
    return 1;
  }

  // Set up the sockaddr_in structure
  memset(&serv_addr, 0, sizeof(serv_addr));
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_port = htons(5000);
  serv_addr.sin_addr.s_addr = INADDR_ANY;

  // Bind the socket to the address
  if (bind(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0) {
    perror("ERROR on binding");
    return 1;
  }

  // Listen for incoming connections
  listen(sockfd, 3);

  // Accept a connection
  if ((portno = accept(sockfd, (struct sockaddr *)NULL, NULL)) < 0) {
    perror("ERROR on accept");
    return 1;
  }

  // Receive data from the client
  n = recv(portno, buffer, sizeof(buffer), 0);
  printf("Received data: %s\n", buffer);

  // Send data back to the client
  if (send(portno, buffer, n, 0) < 0) {
    perror("ERROR sending data");
    return 1;
  }

  // Close the socket
  close(portno);

  return 0;
}