//MISTRAL-7B DATASET v1.0 Category: Checksum Calculator ; Style: minimalist
#include <stdio.h>
#include <stdint.h>
#include <string.h>

#define BLOCK_SIZE 16
#define CHECKSUM_SIZE 4

typedef struct {
    uint8_t data[BLOCK_SIZE];
    uint32_t sum;
} block_t;

void calculate_checksum(block_t *block) {
    for (int i = 0; i < BLOCK_SIZE; i++) {
        block->sum += block->data[i];
    }

    for (int i = 0; i < CHECKSUM_SIZE; i++) {
        uint32_t c = block->sum;
        block->sum = (block->sum >> 8) ^ c;
    }
}

int main() {
    char input[1024];
    int len;
    int block_index = 0;
    int total_blocks = 0;
    block_t blocks[1024 / BLOCK_SIZE];

    fgets(input, sizeof(input), stdin);
    len = strlen(input);

    for (int i = 0; i < len; i += BLOCK_SIZE) {
        memcpy(blocks[block_index++].data, input + i, BLOCK_SIZE > len - i ? BLOCK_SIZE - (len - i) : BLOCK_SIZE);
        if (block_index >= (1024 / BLOCK_SIZE)) {
            fprintf(stderr, "Buffer overflow!\n");
            return 1;
        }

        calculate_checksum(&blocks[total_blocks++]);
    }

    for (int i = 0; i < total_blocks; i++) {
        printf("%02x%02x%02x%02x ",
            (blocks[i].sum) & 0xFF,
            (blocks[i].sum >> 8) & 0xFF,
            (blocks[i].sum >> 16) & 0xFF,
            (blocks[i].sum >> 24) & 0xFF);
    }

    return 0;
}