//GPT-4o-mini DATASET v1.0 Category: Threading Library Implementation ; Style: romantic
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>

#define NUM_ROSES 10

typedef struct {
    char name[50];
    int roses_to_deliver;
} Lover;

void* deliver_roses(void* arg) {
    Lover* lover = (Lover*) arg;

    printf("%s is preparing to deliver roses...\n", lover->name);
    for (int i = 0; i < lover->roses_to_deliver; ++i) {
        printf("%s is placing rose %d on the table of love...\n", lover->name, i + 1);
        sleep(1);  // Simulate the time taken to deliver each rose
    }
    
    printf("%s has delivered %d roses with all his love.\n", lover->name, lover->roses_to_deliver);
    return NULL;
}

void* create_love_message(void* arg) {
    Lover* lover = (Lover*) arg;

    printf("%s starts writing a love message...\n", lover->name);
    sleep(2);  // Simulate time to write a romantic message
    printf("%s's love message: \"You are the rose in my garden of life!\"\n", lover->name);
    return NULL;
}

int main() {
    pthread_t threads[2];
    Lover lover1 = {"Romeo", 5};
    Lover lover2 = {"Juliet", 5};

    printf("In the enchanted garden of love, two lovers plan to meet...\n\n");

    // Create threads for Romeo and Juliet
    pthread_create(&threads[0], NULL, deliver_roses, (void*)&lover1);
    pthread_create(&threads[1], NULL, create_love_message, (void*)&lover2);

    // Wait for both threads to finish
    pthread_join(threads[0], NULL);
    pthread_join(threads[1], NULL);
    
    printf("\nWith their tasks complete, the lovers unite in the moonlight.\n");
    printf("Together they gaze upon the stars, their hearts intertwined.\n");
    printf("For love is not just in the roses delivered, but in the words shared.\n\n");
    printf("A beautiful night brings peace to their souls. The end.\n");

    return 0;
}