//Falcon-180B DATASET v1.0 Category: File system simulation ; Style: irregular
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_FILE_SIZE 1000
#define MAX_NUM_FILES 100

typedef struct {
    char name[100];
    int size;
    char content[MAX_FILE_SIZE];
} File;

File files[MAX_NUM_FILES];
int num_files = 0;

void create_file(char* name, int size) {
    if (num_files >= MAX_NUM_FILES) {
        printf("Error: Too many files.\n");
        return;
    }

    strcpy(files[num_files].name, name);
    files[num_files].size = size;
    num_files++;
}

void delete_file(char* name) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            memset(&files[i], 0, sizeof(File));
            num_files--;
            printf("File %s deleted.\n", name);
            return;
        }
    }

    printf("File not found.\n");
}

void read_file(char* name) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            printf("Contents of %s:\n%s\n", name, files[i].content);
            return;
        }
    }

    printf("File not found.\n");
}

void write_file(char* name, char* content) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            strcpy(files[i].content, content);
            printf("File %s updated.\n", name);
            return;
        }
    }

    printf("File not found.\n");
}

int main() {
    create_file("test.txt", 50);
    create_file("test2.txt", 100);
    write_file("test.txt", "Hello, world!");
    read_file("test.txt");
    delete_file("test2.txt");
    read_file("test2.txt");

    return 0;
}