//Falcon-180B DATASET v1.0 Category: Movie Rating System ; Style: calm
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NAME_LENGTH 100
#define MAX_RATINGS 5

// Movie structure
typedef struct {
    char name[MAX_NAME_LENGTH];
    int ratings[MAX_RATINGS];
    int numRatings;
} Movie;

// Function prototypes
void addMovie(Movie *movies, int numMovies, char *name);
void printMovie(Movie movie);
void rateMovie(Movie *movies, int numMovies, char *name, int rating);
double averageRating(Movie movie);

int main() {
    int numMovies = 0;
    Movie movies[10];

    // Add some movies
    addMovie(movies, numMovies, "The Shawshank Redemption");
    addMovie(movies, numMovies, "The Godfather");
    addMovie(movies, numMovies, "The Dark Knight");

    // Print all movies with their average ratings
    for (int i = 0; i < numMovies; i++) {
        printf("Movie: %s\n", movies[i].name);
        printf("Average rating: %.2f\n\n", averageRating(movies[i]));
    }

    return 0;
}

void addMovie(Movie *movies, int numMovies, char *name) {
    strcpy(movies[numMovies].name, name);
    movies[numMovies].numRatings = 0;
    for (int i = 0; i < MAX_RATINGS; i++) {
        movies[numMovies].ratings[i] = 0;
    }
    numMovies++;
}

void printMovie(Movie movie) {
    printf("Movie: %s\n", movie.name);
}

void rateMovie(Movie *movies, int numMovies, char *name, int rating) {
    int index = -1;
    for (int i = 0; i < numMovies; i++) {
        if (strcmp(movies[i].name, name) == 0) {
            index = i;
            break;
        }
    }

    if (index!= -1) {
        movies[index].ratings[movies[index].numRatings] = rating;
        movies[index].numRatings++;
    }
}

double averageRating(Movie movie) {
    int sum = 0;
    for (int i = 0; i < movie.numRatings; i++) {
        sum += movie.ratings[i];
    }
    return (double) sum / movie.numRatings;
}