//Falcon-180B DATASET v1.0 Category: Network Topology Mapper ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NODES 100
#define MAX_LINKS 200

typedef struct {
    int id;
    char name[20];
    int x, y;
} Node;

typedef struct {
    int id;
    int from, to;
} Link;

Node nodes[MAX_NODES];
Link links[MAX_LINKS];

int num_nodes = 0;
int num_links = 0;

void add_node(int id, char* name, int x, int y) {
    nodes[num_nodes].id = id;
    strcpy(nodes[num_nodes].name, name);
    nodes[num_nodes].x = x;
    nodes[num_nodes].y = y;
    num_nodes++;
}

void add_link(int id, int from, int to) {
    links[num_links].id = id;
    links[num_links].from = from;
    links[num_links].to = to;
    num_links++;
}

int main() {
    // Add nodes
    add_node(1, "Node 1", 0, 0);
    add_node(2, "Node 2", 10, 0);
    add_node(3, "Node 3", 20, 0);
    add_node(4, "Node 4", 30, 0);

    // Add links
    add_link(1, 1, 2);
    add_link(2, 2, 3);
    add_link(3, 3, 4);

    // Print nodes and links
    printf("Nodes:\n");
    for (int i = 0; i < num_nodes; i++) {
        printf("%d. %s (%d,%d)\n", nodes[i].id, nodes[i].name, nodes[i].x, nodes[i].y);
    }

    printf("\nLinks:\n");
    for (int i = 0; i < num_links; i++) {
        printf("%d. From %d to %d\n", links[i].id, links[i].from, links[i].to);
    }

    return 0;
}