//GEMINI-pro DATASET v1.0 Category: Password management ; Style: detailed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PASSWORDS 100
#define MAX_PASSWORD_LENGTH 100

typedef struct {
    char password[MAX_PASSWORD_LENGTH];
    int length;
} password_t;

password_t passwords[MAX_PASSWORDS];
int num_passwords = 0;

void add_password(char *password) {
    if (num_passwords >= MAX_PASSWORDS) {
        printf("Error: Password list is full.\n");
        return;
    }

    passwords[num_passwords].length = strlen(password);
    memcpy(passwords[num_passwords].password, password, passwords[num_passwords].length);
    num_passwords++;
}

char *get_password(char *name) {
    for (int i = 0; i < num_passwords; i++) {
        if (strcmp(name, passwords[i].password) == 0) {
            return passwords[i].password;
        }
    }

    return NULL;
}

int main() {
    add_password("password1");
    add_password("password2");
    add_password("password3");

    char *password = get_password("password2");
    if (password != NULL) {
        printf("Password: %s\n", password);
    } else {
        printf("Error: Password not found.\n");
    }

    return 0;
}