//GEMINI-pro DATASET v1.0 Category: Time Travel Simulator ; Style: interoperable
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define MAX_TIME_TRAVELERS 10

typedef struct TimeTraveler {
  char name[50];
  int year_born;
  int year_traveled_to;
} TimeTraveler;

TimeTraveler time_travelers[MAX_TIME_TRAVELERS] = {
  { "John Doe", 1985, 2020 },
  { "Jane Doe", 1990, 2021 },
  { "Michael Jones", 1975, 2019 },
  { "Sarah Smith", 1980, 2022 },
  { "David Johnson", 1970, 2023 },
  { "Susan Williams", 1985, 2018 },
  { "Thomas Brown", 1990, 2017 },
  { "Mary Johnson", 1980, 2016 },
  { "Robert Davis", 1975, 2015 },
  { "Linda Brown", 1985, 2014 }
};

void print_time_travelers(TimeTraveler *time_travelers, int num_time_travelers) {
  for (int i = 0; i < num_time_travelers; i++) {
    printf("%s traveled from %d to %d\n", time_travelers[i].name, time_travelers[i].year_born, time_travelers[i].year_traveled_to);
  }
}

int main() {
  srand(time(NULL));

  // Randomly select a time traveler to travel to the future
  int time_traveler_index = rand() % MAX_TIME_TRAVELERS;
  TimeTraveler *time_traveler = &time_travelers[time_traveler_index];

  // Randomly select a year in the future for the time traveler to travel to
  int year_traveled_to = rand() % (2023 - time_traveler->year_born) + time_traveler->year_born + 1;

  // Update the time traveler's year traveled to
  time_traveler->year_traveled_to = year_traveled_to;

  // Print out the time traveler's information
  printf("%s traveled from %d to %d\n", time_traveler->name, time_traveler->year_born, year_traveled_to);

  return 0;
}