//Gemma-7B DATASET v1.0 Category: Email Client ; Style: scientific
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netdb.h>

#define PORT 8080
#define MAX_BUFFER_SIZE 1024

int main() {
  int sockfd, newsockfd, clientlen, n;
  char buffer[MAX_BUFFER_SIZE];
  struct sockaddr_in server_addr, client_addr;

  sockfd = socket(AF_INET, SOCK_STREAM, htons(PORT));
  if (sockfd < 0) {
    perror("Error creating socket");
    exit(1);
  }

  server_addr.sin_family = AF_INET;
  server_addr.sin_port = htons(PORT);
  server_addr.sin_addr.s_addr = INADDR_ANY;

  bind(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr));

  clientlen = sizeof(client_addr);

  newsockfd = accept(sockfd, (struct sockaddr *)&client_addr, &clientlen);
  if (newsockfd < 0) {
    perror("Error accepting connection");
    exit(1);
  }

  n = read(newsockfd, buffer, MAX_BUFFER_SIZE);
  if (n < 0) {
    perror("Error reading from socket");
    exit(1);
  }

  printf("Received: %s", buffer);

  n = write(newsockfd, buffer, n);
  if (n < 0) {
    perror("Error writing to socket");
    exit(1);
  }

  close(newsockfd);
  close(sockfd);

  return 0;
}