//LLAMA2-13B DATASET v1.0 Category: Password management ; Style: dynamic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <ctype.h>

#define MAX_PASSWORDS 10
#define MAX_LENGTH 20

typedef struct password_struct {
    char *password;
    int length;
} password_t;

password_t passwords[MAX_PASSWORDS];
int num_passwords = 0;

void add_password(char *password) {
    if (num_passwords == MAX_PASSWORDS) {
        printf("Error: Maximum number of passwords reached (%d)\n", MAX_PASSWORDS);
        return;
    }

    passwords[num_passwords].password = password;
    passwords[num_passwords].length = strlen(password);
    num_passwords++;
}

void list_passwords() {
    printf("Stored passwords:\n");
    for (int i = 0; i < num_passwords; i++) {
        printf("  %s (%d char)\n", passwords[i].password, passwords[i].length);
    }
}

void delete_password(int index) {
    if (index < 0 || index >= num_passwords) {
        printf("Error: Invalid index (%d)\n", index);
        return;
    }

    memmove(passwords + index, passwords + index + 1, (num_passwords - index - 1) * sizeof(password_t));
    num_passwords--;
}

void change_password(int index, char *new_password) {
    if (index < 0 || index >= num_passwords) {
        printf("Error: Invalid index (%d)\n", index);
        return;
    }

    passwords[index].password = new_password;
}

int check_password(char *password) {
    for (int i = 0; i < num_passwords; i++) {
        if (strcmp(password, passwords[i].password) == 0) {
            return i;
        }
    }

    return -1;
}

int main() {
    srand(time(NULL));

    // Add some passwords
    add_password("password1");
    add_password("password2");
    add_password("password3");

    // List all passwords
    list_passwords();

    // Delete a password
    delete_password(1);

    // Change a password
    change_password(0, "new_password1");

    // Check if a password is valid
    int index = check_password("password2");
    if (index != -1) {
        printf("Password 'password2' is valid\n");
    } else {
        printf("Password 'password2' is not valid\n");
    }

    return 0;
}