//Gemma-7B DATASET v1.0 Category: Space Invaders Game Clone ; Style: happy
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define ROWS 5
#define COLS 10

typedef struct invader {
  int x, y;
  char direction;
} invader_t;

invader_t invaders[ROWS][COLS];

void draw_invaders() {
  for (int r = 0; r < ROWS; r++) {
    for (int c = 0; c < COLS; c++) {
      if (invaders[r][c].x != -1) {
        printf("%c ", invaders[r][c].x + 1);
      } else {
        printf(" ");
      }
    }
    printf("\n");
  }
}

void move_invaders() {
  time_t now = time(NULL);
  int delay = now % 5;

  for (int r = 0; r < ROWS; r++) {
    for (int c = 0; c < COLS; c++) {
      if (invaders[r][c].x == -1) {
        continue;
      }

      switch (invaders[r][c].direction) {
        case 'r':
          invaders[r][c].x++;
          break;
        case 'l':
          invaders[r][c].x--;
          break;
        case 'u':
          invaders[r][c].y--;
          break;
        case 'd':
          invaders[r][c].y++;
          break;
      }

      if (invaders[r][c].x >= COLS - 1) {
        invaders[r][c].direction = 'u';
      } else if (invaders[r][c].x <= 0) {
        invaders[r][c].direction = 'r';
      }

      if (invaders[r][c].y >= ROWS - 1) {
        invaders[r][c].direction = 'l';
      } else if (invaders[r][c].y <= 0) {
        invaders[r][c].direction = 'd';
      }
    }
  }
}

int main() {
  for (int r = 0; r < ROWS; r++) {
    for (int c = 0; c < COLS; c++) {
      invaders[r][c].x = -1;
    }
  }

  invaders[0][0].x = 0;
  invaders[0][0].direction = 'r';

  draw_invaders();

  move_invaders();

  draw_invaders();

  return 0;
}