//MISTRAL-7B DATASET v1.0 Category: Database simulation ; Style: shape shifting
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SHAPES 10
#define SHAPE_SIZE 20

typedef struct {
    char name[SHAPE_SIZE];
    int id;
    char shape[SHAPE_SIZE];
} Shape;

Shape shapes[MAX_SHAPES];
int num_shapes = 0;

void create_shape(char *name, int id, char *shape) {
    if (num_shapes < MAX_SHAPES) {
        strcpy(shapes[num_shapes].name, name);
        shapes[num_shapes].id = id;
        strcpy(shapes[num_shapes].shape, shape);
        num_shapes++;
    } else {
        printf("Database is full.\n");
    }
}

Shape *find_shape(int id) {
    for (int i = 0; i < num_shapes; i++) {
        if (shapes[i].id == id) {
            return &shapes[i];
        }
    }
    return NULL;
}

void print_shape(Shape *shape) {
    printf("Shape %d (%s): %s\n", shape->id, shape->name, shape->shape);
}

void change_shape(int id, char *new_shape) {
    Shape *shape = find_shape(id);
    if (shape != NULL) {
        strcpy(shape->shape, new_shape);
        printf("Shape %d (%s) changed to %s.\n", id, shape->name, new_shape);
    } else {
        printf("Shape not found.\n");
    }
}

int main() {
    create_shape("Triangle", 1, "Equilateral");
    create_shape("Circle", 2, "Round");
    create_shape("Square", 3, "Quadrilateral");

    Shape *triangle = find_shape(1);
    print_shape(triangle);

    change_shape(1, "Right-angled triangle");
    triangle = find_shape(1);
    print_shape(triangle);

    Shape *shape = find_shape(4);
    if (shape == NULL) {
        create_shape("Rectangle", 4, "Quadrilateral");
        shape = find_shape(4);
    }
    print_shape(shape);

    change_shape(2, "Oval");
    Shape *circle = find_shape(2);
    print_shape(circle);

    return 0;
}