//Falcon-180B DATASET v1.0 Category: Database Indexing System ; Style: energetic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_KEYS 100
#define MAX_KEY_LENGTH 100
#define MAX_DATA_LENGTH 1000

typedef struct {
    char key[MAX_KEY_LENGTH];
    char data[MAX_DATA_LENGTH];
} Record;

int numRecords = 0;
Record database[MAX_KEYS];

int hash(char *key) {
    int hashValue = 0;
    int i = 0;
    while (key[i]!= '\0') {
        hashValue += key[i];
        i++;
    }
    return hashValue % MAX_KEYS;
}

void insertRecord(char *key, char *data) {
    int index = hash(key);

    while (database[index].key[0]!= '\0') {
        index = (index + 1) % MAX_KEYS;
    }

    strcpy(database[index].key, key);
    strcpy(database[index].data, data);

    numRecords++;
}

void searchRecord(char *key) {
    int index = hash(key);

    while (database[index].key[0]!= '\0') {
        if (strcmp(database[index].key, key) == 0) {
            printf("Key: %s\nData: %s\n", database[index].key, database[index].data);
            return;
        }
        index = (index + 1) % MAX_KEYS;
    }

    printf("Record not found.\n");
}

int main() {
    char key[MAX_KEY_LENGTH] = "John";
    char data[MAX_DATA_LENGTH] = "25";

    insertRecord(key, data);

    searchRecord(key);

    return 0;
}