//GEMINI-pro DATASET v1.0 Category: Geometric algorithms ; Style: inquisitive
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Structure to represent a point in 2D space
typedef struct Point {
    double x;
    double y;
} Point;

// Structure to represent a line segment
typedef struct LineSegment {
    Point p1;
    Point p2;
} LineSegment;

// Structure to represent a circle
typedef struct Circle {
    Point center;
    double radius;
} Circle;

// Function to check if a point is inside a circle
int is_inside_circle(Circle circle, Point point) {
    double dx = point.x - circle.center.x;
    double dy = point.y - circle.center.y;
    double distance = sqrt(dx * dx + dy * dy);
    return distance <= circle.radius;
}

// Function to check if a line segment intersects a circle
int does_intersect_circle(LineSegment line, Circle circle) {
    // Check if the endpoints of the line segment are inside the circle
    int p1_inside = is_inside_circle(circle, line.p1);
    int p2_inside = is_inside_circle(circle, line.p2);

    // If both endpoints are inside the circle, then the line segment is completely inside the circle
    if (p1_inside && p2_inside) {
        return 1;
    }

    // If both endpoints are outside the circle, then the line segment is completely outside the circle
    if (!p1_inside && !p2_inside) {
        return 0;
    }

    // If one endpoint is inside and the other is outside, then the line segment intersects the circle
    return 1;
}

int main() {
    // Create a circle
    Circle circle = {
        .center = {0, 0},
        .radius = 5
    };

    // Create a line segment that intersects the circle
    LineSegment line1 = {
        .p1 = {-5, 5},
        .p2 = {5, 5}
    };

    // Create a line segment that does not intersect the circle
    LineSegment line2 = {
        .p1 = {-5, -5},
        .p2 = {5, -5}
    };

    // Check if the line segments intersect the circle
    int line1_intersects = does_intersect_circle(line1, circle);
    int line2_intersects = does_intersect_circle(line2, circle);

    // Print the results
    printf("Line segment 1 intersects the circle: %s\n", line1_intersects ? "Yes" : "No");
    printf("Line segment 2 intersects the circle: %s\n", line2_intersects ? "Yes" : "No");

    return 0;
}