//MISTRAL-7B DATASET v1.0 Category: Encryption ; Style: Sherlock Holmes
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#define KEY_LENGTH 25
#define TEXT_LENGTH 100

typedef struct {
    char key[KEY_LENGTH];
    char iv[KEY_LENGTH];
} key_iv;

void generate_key(key_iv* key_iv) {
    int i;
    for (i = 0; i < KEY_LENGTH; i++) {
        key_iv->key[i] = 'A' + (rand() % 26);
        key_iv->iv[i] = 'A' + (rand() % 26);
    }
}

void print_key(key_iv key_iv) {
    printf("Encryption Key : ");
    for (int i = 0; i < KEY_LENGTH; i++) {
        printf("%c", key_iv.key[i]);
    }

    printf("\nInitialization Vector : ");
    for (int i = 0; i < KEY_LENGTH; i++) {
        printf("%c", key_iv.iv[i]);
    }
}

void xor_operation(char* text, char* key) {
    for (int i = 0; i < strlen(text); i++) {
        text[i] ^= key[i % KEY_LENGTH];
    }
}

void encrypt_text(char* plain_text, key_iv key_iv) {
    char cipher_text[TEXT_LENGTH];
    xor_operation(plain_text, key_iv.key);
    strcpy(cipher_text, plain_text);
    xor_operation(cipher_text, key_iv.iv);
    printf("\nCipher Text : %s\n", cipher_text);
}

int main() {
    srand(time(NULL));
    key_iv key_iv;
    generate_key(&key_iv);
    print_key(key_iv);

    char plain_text[TEXT_LENGTH] = "I am the greatest detective in the world!";
    encrypt_text(plain_text, key_iv);

    return 0;
}