//Falcon-180B DATASET v1.0 Category: Electronic Voting System ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_CANDIDATES 10
#define MAX_VOTERS 100
#define MAX_NAME_LENGTH 50

typedef struct {
    char name[MAX_NAME_LENGTH];
    int votes;
} candidate;

typedef struct {
    char name[MAX_NAME_LENGTH];
    int voter_id;
    int voted;
} voter;

candidate candidates[MAX_CANDIDATES];
voter voters[MAX_VOTERS];

int num_candidates = 0;
int num_voters = 0;

void add_candidate(char* name) {
    if (num_candidates >= MAX_CANDIDATES) {
        printf("Error: Maximum number of candidates reached.\n");
        return;
    }

    strcpy(candidates[num_candidates].name, name);
    candidates[num_candidates].votes = 0;
    num_candidates++;
}

void add_voter(char* name) {
    if (num_voters >= MAX_VOTERS) {
        printf("Error: Maximum number of voters reached.\n");
        return;
    }

    strcpy(voters[num_voters].name, name);
    voters[num_voters].voter_id = num_voters + 1;
    voters[num_voters].voted = 0;
    num_voters++;
}

void vote(int voter_id, int candidate_id) {
    for (int i = 0; i < num_voters; i++) {
        if (voters[i].voter_id == voter_id &&!voters[i].voted) {
            for (int j = 0; j < num_candidates; j++) {
                if (candidates[j].name[0] == candidate_id + 'A') {
                    candidates[j].votes++;
                    voters[i].voted = 1;
                    break;
                }
            }
            break;
        }
    }
}

void display_results() {
    printf("Election Results:\n");
    for (int i = 0; i < num_candidates; i++) {
        printf("%-20s %d votes\n", candidates[i].name, candidates[i].votes);
    }
}

int main() {
    add_candidate("Alice");
    add_candidate("Bob");
    add_candidate("Charlie");

    add_voter("Alice");
    add_voter("Bob");
    add_voter("Charlie");

    vote(1, 1);
    vote(2, 2);
    vote(3, 3);

    display_results();

    return 0;
}