//Code Llama-13B DATASET v1.0 Category: Socket programming ; Style: distributed
/*
 * Distributed Socket Programming Example
 *
 * This program demonstrates how to create a client-server socket connection
 * in a distributed environment.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#define PORT 8080

int main(int argc, char *argv[]) {
    // Create a socket
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("socket() failed");
        return 1;
    }

    // Set the address of the server
    struct sockaddr_in server_addr;
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(PORT);
    server_addr.sin_addr.s_addr = INADDR_ANY;

    // Connect to the server
    if (connect(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("connect() failed");
        return 1;
    }

    // Send a message to the server
    char *msg = "Hello, server!";
    if (send(sock, msg, strlen(msg), 0) < 0) {
        perror("send() failed");
        return 1;
    }

    // Receive a message from the server
    char buf[1024];
    if (recv(sock, buf, sizeof(buf), 0) < 0) {
        perror("recv() failed");
        return 1;
    }

    // Print the message received from the server
    printf("Received message from server: %s\n", buf);

    // Close the socket
    close(sock);

    return 0;
}