//GEMINI-pro DATASET v1.0 Category: Website Uptime Monitor ; Style: surrealist
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define MAX_URL_LENGTH 256
#define MAX_RESPONSE_LENGTH 4096
#define DEFAULT_PORT 80
#define DEFAULT_TIMEOUT 10
#define DEFAULT_INTERVAL 60

typedef struct {
  char *url;
  int port;
  int timeout;
  int interval;
} website_monitor_config_t;

void usage(char *program_name) {
  printf("Usage: %s [options] <url>\n", program_name);
  printf("Options:\n");
  printf("  -p <port>    Set the port to monitor (default: %d)\n", DEFAULT_PORT);
  printf("  -t <timeout> Set the timeout in seconds (default: %d)\n", DEFAULT_TIMEOUT);
  printf("  -i <interval> Set the interval in seconds between checks (default: %d)\n", DEFAULT_INTERVAL);
  printf("  -h           Display this help message\n");
}

int parse_args(int argc, char **argv, website_monitor_config_t *config) {
  int opt;

  while ((opt = getopt(argc, argv, "p:t:i:h")) != -1) {
    switch (opt) {
      case 'p':
        config->port = atoi(optarg);
        break;
      case 't':
        config->timeout = atoi(optarg);
        break;
      case 'i':
        config->interval = atoi(optarg);
        break;
      case 'h':
        usage(argv[0]);
        exit(0);
      default:
        usage(argv[0]);
        exit(1);
    }
  }

  if (optind >= argc) {
    usage(argv[0]);
    exit(1);
  }

  config->url = argv[optind];

  return 0;
}

int create_socket(char *url, int port) {
  struct sockaddr_in addr;
  struct hostent *host;

  host = gethostbyname(url);
  if (host == NULL) {
    return -1;
  }

  memset(&addr, 0, sizeof(addr));
  addr.sin_family = AF_INET;
  addr.sin_port = htons(port);
  addr.sin_addr = *((struct in_addr *)host->h_addr);

  int sockfd = socket(AF_INET, SOCK_STREAM, 0);
  if (sockfd == -1) {
    return -1;
  }

  if (connect(sockfd, (struct sockaddr *)&addr, sizeof(addr)) == -1) {
    close(sockfd);
    return -1;
  }

  return sockfd;
}

int send_request(int sockfd, char *url) {
  char request[MAX_URL_LENGTH + 8];

  snprintf(request, sizeof(request), "GET / HTTP/1.1\r\nHost: %s\r\nConnection: close\r\n\r\n", url);

  int bytes_sent = send(sockfd, request, strlen(request), 0);
  if (bytes_sent == -1) {
    return -1;
  }

  return bytes_sent;
}

int receive_response(int sockfd, char *response, int max_length) {
  int bytes_received = recv(sockfd, response, max_length, 0);
  if (bytes_received == -1) {
    return -1;
  }

  return bytes_received;
}

int check_website(website_monitor_config_t *config) {
  int sockfd = create_socket(config->url, config->port);
  if (sockfd == -1) {
    return -1;
  }

  int bytes_sent = send_request(sockfd, config->url);
  if (bytes_sent == -1) {
    close(sockfd);
    return -1;
  }

  char response[MAX_RESPONSE_LENGTH];
  int bytes_received = receive_response(sockfd, response, sizeof(response));
  close(sockfd);

  if (bytes_received == -1) {
    return -1;
  }

  if (strstr(response, "HTTP/1.1 200 OK") != NULL) {
    return 1;
  } else {
    return 0;
  }
}

int main(int argc, char **argv) {
  website_monitor_config_t config;

  config.url = NULL;
  config.port = DEFAULT_PORT;
  config.timeout = DEFAULT_TIMEOUT;
  config.interval = DEFAULT_INTERVAL;

  if (parse_args(argc, argv, &config) != 0) {
    return 1;
  }

  while (1) {
    int status = check_website(&config);
    if (status == 1) {
      printf("Website is up\n");
    } else if (status == 0) {
      printf("Website is down\n");
    } else {
      printf("Error checking website\n");
    }

    sleep(config.interval);
  }

  return 0;
}