//Falcon-180B DATASET v1.0 Category: Movie Rating System ; Style: creative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_MOVIES 50
#define MAX_RATINGS 5

struct Movie {
    char title[50];
    char director[50];
    int year;
    int num_ratings;
    int ratings[MAX_RATINGS];
};

void add_movie(struct Movie* movies, int count, char* title, char* director, int year) {
    strcpy(movies[count].title, title);
    strcpy(movies[count].director, director);
    movies[count].year = year;
    movies[count].num_ratings = 0;
}

void add_rating(struct Movie* movies, int count, int rating) {
    movies[count].ratings[movies[count].num_ratings++] = rating;
}

void print_movies(struct Movie* movies, int count) {
    printf("Movie Ratings\n");
    printf("=============================\n");
    for (int i = 0; i < count; i++) {
        printf("%s (%d)\n", movies[i].title, movies[i].year);
        printf("Director: %s\n", movies[i].director);
        printf("Ratings:\n");
        for (int j = 0; j < movies[i].num_ratings; j++) {
            printf("%d stars\n", movies[i].ratings[j]);
        }
        printf("\n");
    }
}

int main() {
    struct Movie movies[MAX_MOVIES];
    int count = 0;

    add_movie(movies, count, "The Shawshank Redemption", "Frank Darabont", 1994);
    add_rating(movies, count, 5);
    add_rating(movies, count, 4);
    add_rating(movies, count, 5);
    add_rating(movies, count, 4);
    add_rating(movies, count, 5);

    add_movie(movies, count, "The Godfather", "Francis Ford Coppola", 1972);
    add_rating(movies, count, 5);
    add_rating(movies, count, 5);
    add_rating(movies, count, 5);
    add_rating(movies, count, 5);
    add_rating(movies, count, 5);

    print_movies(movies, count);

    return 0;
}