//GEMINI-pro DATASET v1.0 Category: Database querying ; Style: protected
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <inttypes.h>
#include <stdbool.h>
#include <ctype.h>

#include <sqlite3.h>

#define MAX_STR_LEN 1000
#define MAX_INT_LEN 20
#define MAX_INT_VAL 1000000000

static int callback(void *data, int argc, char **argv, char **azColName) {
    int i;
    printf("%s: ", (char *)data);
    for (i = 0; i < argc; i++) {
        printf("%s = %s\t", azColName[i], argv[i] ? argv[i] : "NULL");
    }
    printf("\n");
    return 0;
}

int main(int argc, char *argv[]) {
    sqlite3 *db;
    char *zErrMsg = 0;
    int rc;

    /* Open database or create it if it doesn't exist */
    rc = sqlite3_open("example.db", &db);
    if (rc) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        return 1;
    }

    /* Create table if it doesn't exist */
    char *sql = "CREATE TABLE IF NOT EXISTS example (id INTEGER PRIMARY KEY, name TEXT, age INTEGER);";
    rc = sqlite3_exec(db, sql, 0, 0, &zErrMsg);
    if (rc != SQLITE_OK) {
        fprintf(stderr, "Can't create table: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
        sqlite3_close(db);
        return 1;
    }

    /* Insert data into table */
    sql = "INSERT INTO example (name, age) VALUES ('Foo', 42);";
    rc = sqlite3_exec(db, sql, 0, 0, &zErrMsg);
    if (rc != SQLITE_OK) {
        fprintf(stderr, "Can't insert data: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
        sqlite3_close(db);
        return 1;
    }

    /* Query data from table */
    sql = "SELECT * FROM example;";
    rc = sqlite3_exec(db, sql, callback, "Example data", &zErrMsg);
    if (rc != SQLITE_OK) {
        fprintf(stderr, "Can't query data: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
        sqlite3_close(db);
        return 1;
    }

    /* Close database */
    sqlite3_close(db);
    return 0;
}