//GEMINI-pro DATASET v1.0 Category: System administration ; Style: cheerful
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>

int main() {
    // A lovely little greeting to start the day off right
    printf("Greetings from your friendly neighborhood System Administrator!\n");

    // Let's check if you're a special little soul with super-duper permissions
    if (getuid() == 0) {
        printf("Aha! I see you're a member of the rootin' tootin' club! How exciting!\n");
    } else {
        printf("Well, aren't you a regular little user? That's perfectly fine too, my friend!\n");
    }

    // Time to create a sprightly new process!
    pid_t child_pid = fork();

    // Did the fork go swimmingly?
    if (child_pid == 0) {
        // This is the child process's playground
        printf("I'm the child process, ready to do your bidding, master!\n");

        // Let's play a little game called "Hello from the depths of a child process!"
        printf("Hello from the depths of a child process!\n");

        // Time to bid farewell to this mortal coil
        exit(EXIT_SUCCESS);
    } else if (child_pid > 0) {
        // This is the parent process's domain
        printf("I'm the parent process, watching over my child like a proud eagle!\n");

        // Let's wait patiently for our child to finish its tasks
        int status;
        waitpid(child_pid, &status, 0);

        // Did the child process depart this world with grace?
        if (WIFEXITED(status) && WEXITSTATUS(status) == EXIT_SUCCESS) {
            printf("My child has returned from the depths, safe and sound! Hooray!\n");
        } else {
            printf("Oh dear, it seems my child met with an untimely demise. My heart breaks for them.\n");
        }
    } else {
        // Yikes! Something went awry during the fork
        printf("Alas, the fork has failed us! Woe is me!\n");
        return EXIT_FAILURE;
    }

    // And now, my friends, it's time for me to take my leave
    printf("Farewell, my fellow system enthusiasts! May your terminals forever hum with joy!\n");

    return EXIT_SUCCESS;
}