//Falcon-180B DATASET v1.0 Category: Task Scheduler ; Style: imaginative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_TASKS 100
#define MAX_PRIORITY 10
#define MAX_TASK_NAME_LEN 20

typedef struct {
    char name[MAX_TASK_NAME_LEN];
    int priority;
    void (*function)();
} task_t;

task_t tasks[MAX_TASKS];
int num_tasks;

void add_task(char* name, int priority, void (*function)()) {
    strncpy(tasks[num_tasks].name, name, MAX_TASK_NAME_LEN);
    tasks[num_tasks].priority = priority;
    tasks[num_tasks].function = function;
    num_tasks++;
}

void schedule_tasks() {
    int i, j;
    for (i = 0; i < num_tasks; i++) {
        for (j = 0; j < num_tasks - 1; j++) {
            if (tasks[j].priority > tasks[j+1].priority) {
                task_t temp = tasks[j];
                tasks[j] = tasks[j+1];
                tasks[j+1] = temp;
            }
        }
    }
    for (i = 0; i < num_tasks; i++) {
        tasks[i].function();
    }
}

void task1() {
    printf("Task 1 executed.\n");
}

void task2() {
    printf("Task 2 executed.\n");
}

int main() {
    add_task("Task 1", 1, task1);
    add_task("Task 2", 2, task2);
    schedule_tasks();
    return 0;
}