//GEMINI-pro DATASET v1.0 Category: Banking Record System ; Style: surprised
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

#define MAX_ACCOUNTS 100

struct Account {
    unsigned int accountNumber;
    char* name;
    double balance;
};

struct Bank {
    struct Account accounts[MAX_ACCOUNTS];
    unsigned int numAccounts;
};

void createAccount(struct Bank* bank, unsigned int accountNumber, char* name, double balance) {
    if (bank->numAccounts >= MAX_ACCOUNTS) {
        printf("Error: Bank is full!\n");
        return;
    }
    bank->accounts[bank->numAccounts].accountNumber = accountNumber;
    bank->accounts[bank->numAccounts].name = name;
    bank->accounts[bank->numAccounts].balance = balance;
    bank->numAccounts++;
}

void deposit(struct Bank* bank, unsigned int accountNumber, double amount) {
    for (unsigned int i = 0; i < bank->numAccounts; i++) {
        if (bank->accounts[i].accountNumber == accountNumber) {
            bank->accounts[i].balance += amount;
            printf("Deposit successful!\n");
            return;
        }
    }
    printf("Error: Account not found!\n");
}

void withdraw(struct Bank* bank, unsigned int accountNumber, double amount) {
    for (unsigned int i = 0; i < bank->numAccounts; i++) {
        if (bank->accounts[i].accountNumber == accountNumber) {
            if (bank->accounts[i].balance < amount) {
                printf("Error: Insufficient funds!\n");
                return;
            }
            bank->accounts[i].balance -= amount;
            printf("Withdrawal successful!\n");
            return;
        }
    }
    printf("Error: Account not found!\n");
}

void transfer(struct Bank* bank, unsigned int fromAccountNumber, unsigned int toAccountNumber, double amount) {
    for (unsigned int i = 0; i < bank->numAccounts; i++) {
        if (bank->accounts[i].accountNumber == fromAccountNumber) {
            if (bank->accounts[i].balance < amount) {
                printf("Error: Insufficient funds!\n");
                return;
            }
            bank->accounts[i].balance -= amount;
            for (unsigned int j = 0; j < bank->numAccounts; j++) {
                if (bank->accounts[j].accountNumber == toAccountNumber) {
                    bank->accounts[j].balance += amount;
                    printf("Transfer successful!\n");
                    return;
                }
            }
            printf("Error: To account not found!\n");
            return;
        }
    }
    printf("Error: From account not found!\n");
}

void printAccounts(struct Bank* bank) {
    for (unsigned int i = 0; i < bank->numAccounts; i++) {
        printf("Account %d: %s, $%.2f\n", bank->accounts[i].accountNumber, bank->accounts[i].name, bank->accounts[i].balance);
    }
}

int main() {
    struct Bank bank;
    bank.numAccounts = 0;

    createAccount(&bank, 123456, "John Doe", 1000.00);
    createAccount(&bank, 654321, "Jane Smith", 2000.00);
    createAccount(&bank, 789012, "Bob Jones", 3000.00);

    deposit(&bank, 123456, 500.00);
    withdraw(&bank, 654321, 1000.00);
    transfer(&bank, 789012, 123456, 500.00);

    printAccounts(&bank);

    return 0;
}