//GPT-4o-mini DATASET v1.0 Category: Database querying ; Style: interoperable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>

#define DB_NAME "example.db"

// Function prototypes
void create_table(sqlite3 *db);
void insert_data(sqlite3 *db, const char *name, int age);
void query_data(sqlite3 *db);
static int callback(void *NotUsed, int argc, char **argv, char **azColName);

int main() {
    sqlite3 *db;
    int rc;

    // Open database
    rc = sqlite3_open(DB_NAME, &db);
    if (rc) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        return 1;
    }
    
    // Create table
    create_table(db);

    // Insert sample data
    insert_data(db, "Alice", 30);
    insert_data(db, "Bob", 25);
    insert_data(db, "Charlie", 35);

    // Query and display data
    query_data(db);
    
    // Close database
    sqlite3_close(db);
    return 0;
}

void create_table(sqlite3 *db) {
    char *errMsg;
    const char *sql = "CREATE TABLE IF NOT EXISTS PEOPLE("
                      "ID INTEGER PRIMARY KEY AUTOINCREMENT,"
                      "NAME TEXT NOT NULL,"
                      "AGE INT NOT NULL);";

    int rc = sqlite3_exec(db, sql, NULL, 0, &errMsg);
    if (rc != SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    } else {
        printf("Table created successfully\n");
    }
}

void insert_data(sqlite3 *db, const char *name, int age) {
    char *errMsg;
    char sql[256];

    snprintf(sql, sizeof(sql), "INSERT INTO PEOPLE (NAME, AGE) VALUES ('%s', %d);", name, age);
    
    int rc = sqlite3_exec(db, sql, NULL, 0, &errMsg);
    if (rc != SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    } else {
        printf("Inserted (%s, %d) into PEOPLE\n", name, age);
    }
}

void query_data(sqlite3 *db) {
    char *errMsg;
    const char *sql = "SELECT * FROM PEOPLE;";
    
    printf("Querying data from the PEOPLE table...\n");
    
    int rc = sqlite3_exec(db, sql, callback, 0, &errMsg);
    if (rc != SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    }
}

static int callback(void *NotUsed, int argc, char **argv, char **azColName) {
    for (int i = 0; i < argc; i++) {
        printf("%s: %s\n", azColName[i], argv[i] ? argv[i] : "NULL");
    }
    printf("\n");
    return 0;
}