//GPT-4o-mini DATASET v1.0 Category: Building a IMAP Client ; Style: realistic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

#define SERVER "imap://imap.example.com"
#define USERNAME "your_username@example.com"
#define PASSWORD "your_password"

// Callback function to handle data received from the server
size_t write_callback(void *ptr, size_t size, size_t nmemb, char *userdata)
{
    size_t realsize = size * nmemb;
    printf("%.*s", (int)realsize, (char *)ptr);
    return realsize;
}

// Function to list mailboxes
void list_mailboxes(CURL *curl)
{
    CURLcode res;
    
    curl_easy_setopt(curl, CURLOPT_URL, SERVER);
    curl_easy_setopt(curl, CURLOPT_USERPWD, USERNAME ":" PASSWORD);
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, write_callback);
    curl_easy_setopt(curl, CURLOPT_CUSTOMREQUEST, "LIST \"\" \"*\"");

    res = curl_easy_perform(curl);
    if (res != CURLE_OK)
    {
        fprintf(stderr, "curl_easy_perform() failed: %s\n", curl_easy_strerror(res));
    }
}

// Function to get the number of messages in a mailbox
void fetch_mail_count(CURL *curl, const char *mailbox)
{
    CURLcode res;
    char request[256];

    snprintf(request, sizeof(request), "EXAMINE \"%s\"", mailbox);
    curl_easy_setopt(curl, CURLOPT_CUSTOMREQUEST, request);
    
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, write_callback);
    res = curl_easy_perform(curl);
    if (res != CURLE_OK)
    {
        fprintf(stderr, "curl_easy_perform() failed: %s\n", curl_easy_strerror(res));
    }
}

int main(void)
{
    CURL *curl;
    CURLcode res;

    // Initialize libcurl
    curl_global_init(CURL_GLOBAL_DEFAULT);

    // Initialize a curl session
    curl = curl_easy_init();
    if(curl) {
        // Listing mailboxes
        printf("Mailboxes:\n");
        list_mailboxes(curl);

        // Example: assuming the mailbox name is "INBOX"
        fetch_mail_count(curl, "INBOX");

        // Cleanup curl session
        curl_easy_cleanup(curl);
    }
    else {
        fprintf(stderr, "Failed to initialize curl\n");
    }

    // Cleanup global libcurl
    curl_global_cleanup();

    return 0;
}