//Falcon-180B DATASET v1.0 Category: A* Pathfinding Algorithm ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#define MAX_V 100
#define INF INT_MAX

struct edge {
    int v;
    int cost;
    int next;
};

int dist[MAX_V];
int parent[MAX_V];

void dijkstra(int start, int end, int graph[MAX_V][MAX_V], int n) {
    int i, j, u, v;
    for (i = 0; i < n; i++) {
        dist[i] = INF;
        parent[i] = -1;
    }

    dist[start] = 0;

    for (i = 0; i < n - 1; i++) {
        for (j = 0; j < n; j++) {
            if (graph[j][i]!= INF && dist[j]!= INF && dist[j] + graph[j][i] < dist[i]) {
                dist[i] = dist[j] + graph[j][i];
                parent[i] = j;
            }
        }
    }

    for (i = n - 2; i >= 0; i--) {
        u = parent[i];
        v = i;
        printf("%d <- %d\n", v, u);
    }

    printf("Total cost: %d\n", dist[end]);
}

int main() {
    int graph[MAX_V][MAX_V] = {{0, 1, INF, INF},
                                {INF, 0, 2, INF},
                                {INF, INF, 0, 3},
                                {INF, INF, INF, 0}};

    int start = 0, end = 3;

    dijkstra(start, end, graph, 4);

    return 0;
}