//Gemma-7B DATASET v1.0 Category: Haunted House Simulator ; Style: artistic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_GHOULS 10

typedef struct Ghost {
  char name[20];
  int room_num;
  int behavior_code;
} Ghost;

Ghost ghosts[MAX_GHOULS];

void init_ghosts() {
  for (int i = 0; i < MAX_GHOULS; i++) {
    ghosts[i].name[0] = '\0';
    ghosts[i].room_num = -1;
    ghosts[i].behavior_code = -1;
  }
}

void add_ghost(char *name, int room_num, int behavior_code) {
  for (int i = 0; i < MAX_GHOULS; i++) {
    if (ghosts[i].name[0] == '\0') {
      strcpy(ghosts[i].name, name);
      ghosts[i].room_num = room_num;
      ghosts[i].behavior_code = behavior_code;
      return;
    }
  }
  printf("Error: No more ghosts can be added.\n");
}

void simulate_haunted_house() {
  srand(time(NULL));

  for (int i = 0; i < MAX_GHOULS; i++) {
    if (ghosts[i].name[0] != '\0') {
      int room_num = ghosts[i].room_num;
      int behavior_code = ghosts[i].behavior_code;

      switch (behavior_code) {
        case 0:
          printf("%s whispers secrets in your ear.\n", ghosts[i].name);
          break;
        case 1:
          printf("%s moves freely through the halls.\n", ghosts[i].name);
          break;
        case 2:
          printf("%s tries to scare you.\n", ghosts[i].name);
          break;
        default:
          break;
      }
    }
  }
}

int main() {
  init_ghosts();

  add_ghost("Mr. Jones", 1, 0);
  add_ghost("Mrs. Smith", 3, 1);
  add_ghost("The Phantom", 5, 2);

  simulate_haunted_house();

  return 0;
}